/*
 * userint.c-- these routines make up the user interface.  They are
 * mostly portable, with the exception of the routines which detect
 * whether a key has been pressed.  However, they may be changed to
 * handle system-call i/o like pull-down menues, mouse buttons, etc.
 */

#include <conio.h>
#include "juggle.h"
#include "proto.h"


/*
 * keypressed returns zero if no key has been pushed, nonzero otherwise.
 * clearkeyb resets the flag.  Very implementation-dependant.
 */

int keypressed(void)
{
   return kbhit();
}

void clearkeyb(void)
{
   while (kbhit())
      getch();
}

/*
 * getpattern -- now, just trivial i/o, but may use menues, etc.
 */

void getpattern(char *buffer)
{
   printf ("Enter pattern: ");
   if (gets(buffer) == NULL) {
      fprintf (stderr, "getpattern: input error\n");
      exit(1);
   }
}


/*
 * getoptions -- allows user to change certain global constants. For now,
 * height_counts and catch_counts are the only ones that can be changed.
 * hold_two_flag and maxballs may in future versions.
 */

void getoptions(void)
{
   char  inbuf[20];
   int   i;
   float ratio;

   printf ("\nOptions that may be changed: \n"
           "  Frames per beat:  more = slower and smoother animation.\n"
           "  Hand time:  how long a ball is held.  Must be 0-2.\n\n"
           "Current values: %i and %.2g\n"
           "For more explanation, see the accompanying doc file.\n",
           height_counts, hold_beats);

   printf ("Frames per beat (return for %i): ", height_counts);

   if (sscanf(gets(inbuf), "%i", &i) && i>0)
      height_counts = i;
   printf ("Hand time (return for %.2g): ", hold_beats);
   if (sscanf(gets(inbuf), "%f", &ratio) && ratio > 0 && ratio < 2)
      hold_beats = ratio;
   catch_counts = (int) (height_counts * hold_beats);

   printf ("New values: %i and %.2g\n",
            height_counts, hold_beats);

}
